﻿# Towards Zero Memory Footprint Spiking Neural Network Training

## Introduction
Our code contains two types of reversible Spiking Neural Network (SNN) nodes: *Neuron_Origianl_reversible_layer_architecture* and *Neuron_Inverse_calculation gradient*. The former utilizes the original reversible layer backward architecture, while the latter employs an inverse gradient calculation method. Both of them are designed to optimize SNN training memory. In terms of training speed, the *Neuron_Inverse_calculation gradient* node trains faster than the *Neuron_Origianl_reversible_layer_architecture* node.

If you wish to compare the memory usage or training time of SNNs, you can replace the original SNN nodes with our reversible SNN nodes and test with specific data.

We are still tidying up the code and will soon release a more user-friendly version.

## Experiment Reproduce
We use an existing SNN framework (from https://github.com/intelligent-computing-lab-yale/exploring-lottery-ticket-hypothesis-in-snns and https://github.com/fangwei123456/spikingjelly) to perform our experiments. First set the sparsity in their code to zero, and then replace the original SNN node with our designed SNN node to repeat our experiment. 
For the memory measurment: We use torch.cuda.memory_allocated() to test the memory usage for each step.
For the training time: We use torch.cuda.Event(enable_timing=True).record() to test the duration for each step.
